package edu.wisc.game.rest;

import java.io.*;
import java.util.*;
import javax.json.*;
import javax.persistence.*;


import javax.xml.bind.annotation.XmlElement; 
import javax.xml.bind.annotation.XmlRootElement;

import edu.wisc.game.util.*;
import edu.wisc.game.engine.*;
import edu.wisc.game.sql.*;


public class ResponseBase {
    boolean error=false;
    String errmsg=null;
    
    public boolean getError() { return error; }
    @XmlElement
    public void setError(boolean _error) { error = _error; }
    
    public String getErrmsg() { return errmsg; }
    @XmlElement
    public void setErrmsg(String _errmsg) { errmsg = _errmsg; }

    ResponseBase( ) {}

    ResponseBase( boolean _error,     String _errmsg) {
	setError(_error);
	setErrmsg( _errmsg);
    }

    void hasError(String msg) {
	Logging.error(msg);
	setError(true);
	setErrmsg(msg);
    }

    /** Regularize an input parameter, converting a blank string to null */
    static String regularize(String x) {
	if (x!=null && (x.trim().equals("") || x.equals("null"))) x=null;
	return x;
    }


    
}
