# Supplementary Material for FARI

## Introduction

FARI is a fast and robust asymmetric inversion method designed specifically for inversion-based watermarking.

## Usage

We recommend using Python 3.11. Key dependencies are listed in `requirements.txt`, which can be conveniently installed via `pip install -r requirements.txt`.

For the LoRA implementation, we use https://github.com/cloneofsimo/lora instead of the solutions provided by `diffusers` or `peft`, as its code has significantly lower coupling, making it easier to read and understand.

This repository contains three main scripts:
- `train.py`: Used to train FARI.
- `val_gs.py`: Used to evaluate FARI's performance on Gaussian Shading.
- `val_tr.py`: Used to evaluate FARI's performance on Tree-Ring.

Regarding command-line arguments, the default values are well-configured and are the same as those used in our paper. You may modify them as needed, but please ensure that the same `--name` argument is used for both the training and validation of a given model.

As FARI is very lightweight, we also provide our pretrained weights at `./results/fari_default/fari_weights.pth`, which were trained using the default settings.

> **Note:** The COCO prompts and ground-truth images used in our experiments are available [here](https://drive.google.com/drive/folders/1saWx-B3vJxzspJ-LaXSEn5Qjm8NIs3r0), sourced from the [Tree-Ring Watermark](https://github.com/YuxinWenRick/tree-ring-watermark.git) repository.

## Code Structure

Here, we describe the code structure within the `src` folder to help you understand our implementation.

In `src/inversion/inv_pipe.py`, we define a custom `StableDiffusionPipeline` for inversion, primarily by adding several utility methods such as `ddim_inversion` and `get_image_latents`.

In `src/fari.py`, we define the core implementation of FARI. By using Python's context managers, we can easily enable or disable the LoRA branch during generation and inversion by combining our custom classes.

`src/watermark.py` contains the implementation of Gaussian Shading, sourced from its original official repository: https://github.com/bsmhmmlf/Gaussian-Shading.git

`src/io_utils.py` and `src/optim_utils.py` contain the implementation of Tree-Ring, sourced from its original official repository: https://github.com/YuxinWenRick/tree-ring-watermark.git

`src/utils.py` is where we define several utility functions, including functions for loading datasets and applying distortions to images.

## Baselines

The code or checkpoints for other baseline methods is provided below:

- EDICT, BELM: https://github.com/zituitui/BELM
- ExactDPM: https://github.com/smhongok/inv-dpm
- AMED-Solver: https://github.com/zju-pi/diff-sampler
- LCM-LoRA: https://huggingface.co/latent-consistency/lcm-lora-sdv1-5
- DMD2: https://huggingface.co/tianweiy/DMD2