import torch
from tqdm import tqdm

def calculate_perplexity(model, valid_loader, device, pad_token_id=None):
    model.eval()
    nll_sum = 0.0
    n_tokens = 0

    for inputs, targets in tqdm(valid_loader):
        inputs = inputs.to(device)
        targets = targets.to(device)

        with torch.no_grad():
            outputs = model(inputs, labels=targets)
            neg_log_likelihood = outputs.loss.to(torch.float32)

        if pad_token_id is not None:
            num_valid_tokens = (targets != pad_token_id).sum().item()
        else:
            num_valid_tokens = targets.numel()

        nll_sum += neg_log_likelihood * num_valid_tokens
        n_tokens += num_valid_tokens

        torch.cuda.empty_cache()

    avg_nll = nll_sum / n_tokens
    ppl = torch.exp(avg_nll)
    return ppl

