# AutoTTV - Automated Transit Timing Variation Analysis for WASP-4b

## Overview

This repository contains a Jupyter notebook that performs automated transit timing variation (TTV) analysis for the hot Jupiter exoplanet WASP-4b using TESS (Transiting Exoplanet Survey Satellite) photometric data.

## Features

- **Automated Transit Timing Extraction**: Measures precise mid-transit times for 64 individual transits
- **Multi-model Ephemeris Fitting**: Compares linear vs quadratic ephemerides using Bayesian Information Criterion
- **Transit Morphology Analysis**: Fits Batman transit models with proper uncertainty propagation
- **Secondary Eclipse Detection**: Stacks and analyzes thermal emission during secondary eclipses
- **Publication-Ready Visualizations**: Generates high-quality plots for scientific publication

## Requirements

### Python Packages
```
numpy < 2.0
batman-package == 2.4.9
pandas < 2.0
matplotlib < 4.0
astropy < 6.0
scipy < 2.0
```

### Data Files
The notebook requires TESS light curve FITS files for WASP-4b from sectors 2, 28, 29, and 69:
- `tess2018234235059-s0002-0000000402026209-0121-s_lc.fits`
- `tess2020212050318-s0028-0000000402026209-0190-s_lc.fits`
- `tess2020238165205-s0029-0000000402026209-0193-s_lc.fits`
- `tess2023237165326-s0069-0000000402026209-0264-s_lc.fits`

These files should be placed in a directory accessible to the notebook (default: `/content/drive/MyDrive/AutoTTV/` for Google Colab).

## Installation
1. Install required packages:
```bash
pip install "numpy<2.0" "batman-package==2.4.9" "pandas<2.0" "matplotlib<4.0" "astropy<6.0" "scipy<2.0"
```

2. Download TESS light curves from [MAST](https://mast.stsci.edu/) or use the provided paths if running on Google Colab

## Usage

### Google Colab
1. Open `autottv1.ipynb` in Google Colab
2. Mount your Google Drive containing the TESS data files
3. Run all cells sequentially

### Local Jupyter
1. Start Jupyter Notebook:
```bash
jupyter notebook autottv1.ipynb
```
2. Update the file paths in the notebook to point to your local TESS data
3. Run all cells sequentially

## Analysis Pipeline

### 1. Data Loading and Preprocessing
- Reads TESS PDCSAP (Pre-search Data Conditioning Simple Aperture Photometry) light curves
- Applies quality flags and removes bad data points
- Converts TESS time (BTJD) to BJD_TDB

### 2. Transit Timing Extraction
- Identifies individual transits using ephemeris predictions
- Fits Batman transit models to each transit
- Measures mid-transit times with uncertainties
- Typical precision: ~40-50 seconds per transit

### 3. Ephemeris Fitting
- **Linear Model**: T(E) = T₀ + P × E
- **Quadratic Model**: T(E) = T₀ + P × E + ½Q × E²
- Uses weighted least squares fitting
- Computes period derivative: Ṗ = Q/P

### 4. Model Selection
- Calculates χ² statistics for both models
- Computes Bayesian Information Criterion (BIC)
- ΔBIC = -307.48 strongly favors quadratic model

### 5. Transit Stacking
- Phase-folds all transits to common ephemeris
- Bins data for improved signal-to-noise
- Measures transit depth: ~21,000 ppm
- Creates publication-quality transit plot

### 6. Secondary Eclipse Analysis
- Stacks secondary eclipses at phase 0.5
- Fits box model to measure eclipse depth
- Detection: 265 ± 45 ppm (SNR = 5.9)
- Indicates thermal emission from planet's dayside

## Output Files

The notebook generates several output files in `wasp4b_outputs/`:
- `TESS_per_transit_midtimes.csv`: Individual transit times from TESS
- `literature_midtimes.csv`: Published transit times from literature
- `fit_summary.txt`: Ephemeris parameters and statistics
- Transit and eclipse plots (if saved)


## Known Issues

- Some package version conflicts may occur in Google Colab due to pre-installed packages
- The notebook requires restart after installing packages to properly load numpy<2.0

## License

MIT

## Acknowledgments

- TESS data provided by NASA/MIT
- Batman package by Laura Kreidberg
- Additional literature transit times from Wilson et al. (2008), Gillon et al. (2009), Huitson et al. (2017), Southworth et al. (2019)