# 开发时间 2024/11/12 12:57
import numpy as np
import matplotlib.pyplot as plt

# 定义x的范围
x = np.linspace(0, 2*np.pi, 1000)

# 定义函数
f1 = np.cos(x) + 0.5 * np.sin(4/5 * np.pi * x)
f2 = np.cos(x)

# 创建图像
plt.figure(figsize=(8, 6))
plt.plot(x, f1, label=r'$f(x) = \cos(x) + 0.5\sin(2\pi x)$', color='b')
plt.plot(x, f2, label=r'$f(x) = \cos(x)$', color='r', linestyle='--')

# 添加标签和标题
plt.xlabel(r'$x$')
plt.ylabel(r'$f(x)$')
plt.title('Graph of $f(x) = \cos(x) + 0.5\sin(2\pi x)$ and $f(x) = \cos(x)$')
plt.legend()

# 显示网格
plt.grid(True)

# 显示图像
plt.show()
