import numpy as np
import matplotlib.pyplot as plt

# 定义函数
# def f(x):
#     return -(2/5)*x**4 + 1.5*x**2
#
# # 定义x的取值范围
# x = np.linspace(-1.8, 1.8, 400)
#
# # 计算y的值
# y = f(x)
def f(x):
    return np.exp(x**3 - 2*x**2) - 1

# 创建 x 的取值范围
x = np.linspace(-1.5, 0.5, 400)  # 你可以调整范围和点的数量

# 计算 y 的取值
y = f(x)
y_1 = x
# 画图

plt.figure(figsize=(8, 6))
plt.plot(x, y, label=r'$y = exp(x^3-2x^2)-1$', color='b',linewidth =3)
plt.plot(x, y_1,label=r'$y = x$', color ='green',linewidth =3)

plt.xticks(fontweight='bold',fontsize = 13)  # 加粗 x 轴刻度标签
plt.yticks(fontweight='bold',fontsize = 13)


plt.scatter(-0.910, -0.910, label='Fixed Point',color='r', zorder=5, s=100)
plt.scatter(0, 0, color='r', zorder=5, s=100)
plt.legend(loc='lower right',fontsize=21)
plt.title("Exponential Function Case",fontsize=20,fontweight='bold')

plt.xlabel('x',fontsize=22, fontweight='bold')
plt.ylabel('y',fontsize=22, fontweight='bold')

plt.grid(True)
plt.axhline(0, color='black',linewidth=1)
plt.axvline(0, color='black',linewidth=1)
plt.tight_layout()

plt.savefig('Exponential Function Case.pdf',format='pdf',dpi=300)
plt.show()