#!/bin/bash
#SBATCH --job-name=qm9 # Job name
#SBATCH --nodes=1
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=15
#SBATCH --gpus=4
#SBATCH --mem=160gb
#SBATCH --time=72:00:00
#SBATCH --output=../logs/grit%j.log


module load devel/julia
module load devel/python/3.8.13
module load containers/singularity

singularity exec --nv ../pyg_dgl_grit\:latest python main.py --cfg configs/GRIT/zinc-GRIT-RRWP-quantum.yaml  wandb.use False accelerator "cuda:0" seed 0  &
singularity exec --nv ../pyg_dgl_grit\:latest python main.py --cfg configs/GRIT/zinc-GRIT-RRWP-quantum.yaml  wandb.use False accelerator "cuda:1" seed 1  &
singularity exec --nv ../pyg_dgl_grit\:latest python main.py --cfg configs/GRIT/zinc-GRIT-RRWP-quantum.yaml  wandb.use False accelerator "cuda:2" seed 2  &
singularity exec --nv ../pyg_dgl_grit\:latest python main.py --cfg configs/GRIT/zinc-GRIT-RRWP-quantum.yaml  wandb.use False accelerator "cuda:3" seed 3