# README
This repo is the official implementation of Enhancing Graph Neural Networks with Quantum Computed Encodings. The template of the README is taken from https://github.com/LiamMa/GRIT.

> The implementation is based on [GRIT (Ma et al., 2023)](https://github.com/LiamMa/GRIT) itself based on [GraphGPS (Rampasek et al., 2022)](https://github.com/rampasek/GraphGPS).

### Python environment setup
```bash
# please change the cuda/device version as you need

pip install torch==1.12.1+cu113 torchvision==0.13.1+cu113 torchaudio==0.12.1 --extra-index-url https://download.pytorch.org/whl/cu113 --trusted-host download.pytorch.org
pip install torch-scatter torch-sparse torch-cluster torch-spline-conv torch-geometric==2.2.0 -f https://data.pyg.org/whl/torch-1.12.1+cu113.html --trusted-host data.pyg.org

# RDKit is required for OGB-LSC PCQM4Mv2 and datasets derived from it.  
pip install rdkit

pip install torchmetrics==0.9.1
pip install ogb
pip install tensorboardX
pip install yacs
pip install opt_einsum
pip install graphgym 
pip install pytorch-lightning # required by graphgym 
pip install setuptools==59.5.0

```

### Running the experiments
```bash
# Run
python main.py --cfg configs/GRIT/zinc-GRIT-RRWP-quantum-xy-adj.yaml  wandb.use False accelerator "cuda:0" optim.max_epoch 2000 seed 41 dataset.dir 'xx/xx/data'

# replace 'cuda:0' with the device to use
# replace 'xx/xx/data' with your data-dir (by default './datasets")
# replace 'configs/GRIT/zinc-GRIT.yaml' with any experiments to run
```

### Configurations and Scripts

- Configurations are available under `./configs/GRIT/xxxxx.yaml`
- Scripts to execute are available under `./scripts/xxx.sh`
  - will run 4 trials of experiments parallelly on `GPU:0,1,2,3`.
  
### Isomorphism appendix A.3.1

The code to reproduce the experiments to distinguish strongly regular graphs by the 2-QiRW is in the folder `isomorphism`

