#!/bin/bash

# Careful that there is no space after the # <--> SBATCH commands!
#SBATCH --job-name=struct0          # Job name
#SBATCH --nodes=1                    # Run all processes on a single node
#SBATCH --ntasks=1                   # Number of (MPI) processes is 1 since we don't use MPI
#SBATCH --cpus-per-task=1         # Number of CPU cores per task
#SBATCH --gpus-per-task=1
#SBATCH --time=72:00:00              # Time limit hrs:min:sec
#SBATCH --mem-per-cpu=200G
# SBATCH --nodelist node01
#SBATCH --output=./results/struct_%j.log # Standard output and error log

# Execution time, host and current dir
date;hostname;pwd


python3.9 main.py --cfg configs/GRIT/peptides-struct-GRIT-QRRWP.yaml wandb.use False accelerator "cuda:0" seed 0