# Posterior Sampling Based on Gradient Flows of the MMD with Negative Distance Kernel

This code belongs to the paper 'Posterior Sampling Based on Gradient Flows of the MMD with Negative Distance Kernel'. It contains implementations for the experiments of Section 4.

## 1. REQUIREMENTS

We tested the code with python 3.9.13 and the following package versions:

- pytorch 1.21.1
- matplotlib 3.6.1
- scikit-image 0.19.3
- dival 0.6.1
- odl 1.0.0

Usually, the code is also compatible with some other versions of the corresponding packages.

## 2. USAGE 

You can start the training of the conditional MMD flow by calling the script 'run_{dataset}_{setting}.py' for the datasets MNIST, FashionMNIST, CIFAR10 and CelebA as well as a CT dataset and a material's microstructures dataset. For CT you have the choice between the limited angle setting, which is the default setting, and the low-dose setting, for which you need to set the flag 'lowdose' to True.
If you do not wish to save intermediate steps of the flow, then set the flag 'save' to False.
If you already have trained the conditional MMD flow and want to visualize the results, then set the flag 'visualize' to True.
