import numpy as np
import torch
import os
import sys
import argparse
import matplotlib.pyplot as plt

sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
from Javanmard2019_RMLP2.RMLP2 import *
from env import *

model_list = ['linear']
cdf_type_list = ['gaussian', 'MoU']
context_type_list = ['gaussian', 'uniform', 'binary']

algo_name = 'RMLP2'

W_set = [1, 2, 4, 8, 16]


if __name__=='__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument('--cuda', type=str, default='0')
    parser.add_argument('--search', action='store_true')
    args = parser.parse_args()

    os.environ["CUDA_VISIBLE_DEVICES"]= args.cuda

    device = "cuda" if torch.cuda.is_available() else "cpu"
    env_generator = torch.Generator(device=device)
    algo_generator = torch.Generator(device=device)

    for model in model_list:
        for cdf_type in cdf_type_list:
            for context_type in context_type_list:
                print(f'model={model}_cdf={cdf_type}_context={context_type}')

                d = 5
                T = 3000
                rep = 5
                env_seed = algo_seed = 1234

                basedir = f'search/sim_d={d}_T={T}/model={model}/cdf={cdf_type}/context={context_type}/{algo_name}'
                if not os.path.exists(basedir):
                    os.makedirs(basedir)

                if context_type=='gaussian':
                    context_dist = GaussianContext(d=d, sigma=1, generator=env_generator, device=device)
                elif context_type=='uniform':
                    context_dist = UniformContext(d=d, device=device, generator=env_generator)
                elif context_type=='binary':
                    context_dist = BinaryContext(d=d, device=device, generator=env_generator)
                else:
                    raise NotImplementedError
                
                if cdf_type=='gaussian':
                    cdf = gaussian_cdf
                elif cdf_type=='MoU':
                    cdf = MoU_cdf
                else:
                    raise NotImplementedError

                if model=='linear':
                    valuation_model = LinearModel(d=d, cdf=cdf, device=device)
                elif model=='loglinear':
                    valuation_model = LogLinearModel(d=d, cdf=cdf, device=device)
                    raise NotImplementedError
                env = Env(generator=env_generator, context_dist=context_dist, valuation_model=valuation_model)
                
                if args.search:
                    for W in W_set:
                        print(f'W={W}')
                        env_generator.manual_seed(env_seed)
                        algo_generator.manual_seed(algo_seed)

                        algo = RMLP2(d, W, T)
                        algo.run(rep=rep, env=env, basedir=f'{basedir}/W={W}')
                
                best = 1e9
                for W in W_set:
                    dir=f'{basedir}/W={W}'
                    reward = np.load(dir+'/reward.npy')
                    optimal_reward = np.load(dir+'/optimal_reward.npy')
                    mean_regret = np.mean(optimal_reward-reward)
                    if mean_regret < best:
                        best = mean_regret
                        best_param = W
                    print(f'W={W}: {mean_regret}')
                
                # run with the best parameter
                print(f'best parameter : W={best_param}')

                W = best_param
                d = 5
                T = 30000
                rep = 5
                env_seed = algo_seed = 123
                basedir = f'results/sim_d={d}_T={T}/model={model}/cdf={cdf_type}/context={context_type}/{algo_name}'

                env_generator.manual_seed(env_seed)
                algo_generator.manual_seed(algo_seed)
                algo = RMLP2(d, W, T)
                algo.run(rep=rep, env=env, basedir=basedir)