# Neural Dynamic Pricing: Provable and Practical Efficiency

Official implementation of the paper "Neural Dynamic Pricing: Provable and Practical Efficiency".

## Implemented Algortihms

### Dynamic Pricing Algorithms
- `Ours_DP_IGW/` : Our proposed algorithm `DP-IGW`
- `Choi2023_CoxCP/` : Semi-parametric DP algorithm in [Choi et al., 2023](https://proceedings.mlr.press/v202/choi23c.html). Due to the dependency on the regrssion package, `CoxCP` depends on `rpy` package.
- `Fan2022/` : Semi-parametric DP algorithm in [Fan et al., 2022](https://www.tandfonline.com/doi/full/10.1080/01621459.2022.2128359?casa_token=MjqqfUhtGRgAAAAA%3AoyjKgquxU8-kfViwsfoyWE7BQKtKekgIUWJ1H-WxAmhrmMauKAYIC3dYJmXCpiMMGGR41z_KTO9dyCU)
- `Luo2022_ExUCB/` : Semi-parametric DP algorithm in [Luo et al., 2022](https://proceedings.neurips.cc/paper_files/paper/2022/hash/f38d1fd25c15a0ad9ba758de4e7b1819-Abstract-Conference.html)
- `Shah2019_DEEP-C/` : Semi-parametric DP algorithm in [Shah et al., 2019](https://proceedings.neurips.cc/paper/2019/hash/363763e5c3dc3a68b399058c34aecf2c-Abstract.html)
- `Chen2021_ABE/` : Nonparametric DP algorithm in [Chen & Gallego., 2021](https://pubsonline.informs.org/doi/abs/10.1287/opre.2020.2016?casa_token=4EDh4UI9cS4AAAAA:M8NSHKKQg30OYclalPqtg_iCloGiJMZLTl4M3BLxLOLXyTpjUac40lsj-qFAMl8wj3HN5c-gawTh_g)
- `Javanmard2019_RMLP`, `Javanmard2019_RMLP2` : Parametric DP algorithm in [Javanmard & Nazerzadeh, 2019](https://scholar.google.com/scholar?start=10&hl=ko&as_sdt=0,5&scilib=1033)
- `Xu2021_ONSP/` : Parametric DP algorithm in [Xu & Wang, 2021](https://proceedings.neurips.cc/paper_files/paper/2021/hash/742141ceda6b8f6786609d31c8ef129f-Abstract.html)

### Contextual Bandit Algorithms
- `Zhou2020_NeuralUCB/` : Neural bandit algorithm in [Zhou et al.,2020](https://proceedings.mlr.press/v119/zhou20a.html)
- `Zhang2020_NeuralTS/` : Neural bandit algorithm in [Zhang et al.,2020](https://arxiv.org/abs/2010.00827)
- `Foster2020_SquareCB/` : Regression oracle based bandit algorithm in [Foster & Rakhlin, 2020](https://proceedings.mlr.press/v119/foster20a)
- `Zhu2022_SmoothIGW/` : Regression oracle based bandit algorithm in [Zhu & Mineiro, 2020](https://proceedings.mlr.press/v162/zhu22h.html)


## Enviornment
Install packages using `environment.yml` file.
```
conda env create -f environment.yml
```

## Training Guide
To run each algorithm "algo_name" in simulation environments, run `sim_[algo_name].py` file.
The `sim_[algo_name].py` file includes some settings for experiments:
- `model_list` : The list of valuation models; `linear`, `loglinear`, `PH` are available. The program iterates through all valuation models in the list.
- `cdf_type_list` : The list of base CDFs; , `gaussian`, `MoU` are available. The program iterates through all base CDFs in the list.
- `context_type_list` : The list of context distributions; `gaussian`, `uniform`, `binary` are available. The program iterates through all context distributions in the list.
- `d` : The dimension of the contexts
- `T` : The horizon. The search stage and the execute stage (with the best hyperparameter) use different `T`.
- `rep` : The number of runs for each combination of setting.

To run each algorithm "algo_name" with real-world datasets, run `real_[algo_name].py` file.
The `real_[algo_name].py` file includes some settings for experiments:
- `cdf_type_list` : The list of base CDFs; , `gaussian`, `MoU` are available. The program iterates through all base CDFs in the list.
- `T` : The horizon. The search stage and the execute stage (with the best hyperparameter) use different `T`.
- `rep` : The number of runs for each combination of setting.

Including `--search` option, the program performs hyperparameter search then run the algorithm with the best hyperparameter.
The search results are stored in `./search`, and the data with the best hyperparameter are stored in `./results` as numpy arrays.
Execution without `--search` option run the algorithm with the best parameter. In this case, the search data must exist.
For example, the following command conducts hyperparameter search for the `DP-IGW` algorithm with real-world datasets, then execute it with best hyperparameter.
```
python Ours_DP_IGW/real_DP-IGW.py --search
```

## License

This project is released under the [CC0 1.0 Universal (CC0 1.0) Public Domain Dedication](https://creativecommons.org/publicdomain/zero/1.0/).

To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this project to the public domain worldwide. This means you can copy, modify, distribute, and perform the work, even for commercial purposes, all without asking permission.