"""Interface definition of agent builder."""
import abc
from typing import TypeVar

import acme
from acme import specs
from acme.jax import networks as networks_lib
from ml_collections import ConfigDict

Networks = TypeVar("Networks")
Learner = TypeVar("Learner")


class AgentBuilder(abc.ABC):

  @abc.abstractstaticmethod
  def make_default_configs() -> ConfigDict:
    """Default configs."""

  @abc.abstractmethod
  def make_networks(
    self, env_spec: specs.EnvironmentSpec, **kwargs
  ) -> Networks:
    """Networks."""

  @abc.abstractmethod
  def make_learner(self, **kwargs) -> Learner:
    """Learner (with optimizers)."""

  @abc.abstractmethod
  def make_evaluator(
    self, networks: Networks, learner: Learner, rng_key: networks_lib.PRNGKey
  ) -> acme.Actor:
    """Evaluating actor."""
