from .q_learner import QLearner
from .noise_q_learner import QLearner as NoiseQLearner
from .tee_q_learner import QLearner as TEEQLearner
from .coma_learner import COMALearner
from .actor_critic_learner import ActorCriticLearner
from .qtran_learner import QLearner as Qtranlearner
from .ppo_learner import PPOLearner as PPOLearner
from .tee_ppo_learner import PPOLearner as TEEPPOLearner

REGISTRY = {}

REGISTRY["q_learner"] = QLearner
REGISTRY["noise_q_learner"] = NoiseQLearner
REGISTRY["tee_q_learner"] = TEEQLearner
REGISTRY["coma_learner"] = COMALearner
REGISTRY["actor_critic_learner"] = ActorCriticLearner
REGISTRY["qtran_learner"] = Qtranlearner
REGISTRY["ppo_learner"] = PPOLearner
REGISTRY["tee_ppo_learner"] = TEEPPOLearner
