import pickle
import matplotlib.pyplot as plt

# betas = [0.5, 0.4, 0.3, 0.38, 0.2, 0.1]
# betas = [1.0, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1]
# betas=[0.45, 0.43, 0.42, 0.41, 0.4, 0.39, 0.38, 0.36, 0.35]

# betas=[0.435, 0.425, 0.415, 0.4, 0.405, 0.395, 1.0]
betas=[1.0, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1]
# betas = [1.0, 0.333, 0.666, 0.146, 0.428]

names = [str(round(b,3)) for b in betas]

path1 = r'./vrzht/'
path2 = r'./saga/'
paths = [path2, path1]
for path in paths:

    curves = []

    result_path = path + 'results/'
    alg = path.split('/')[1]
    print(result_path)

    for beta in betas:
        with open(result_path + f'{str(round(beta,3))}_{alg}_curves.pickle', 'rb') as file:
            curve = pickle.load(file)
            curves.append(curve)

    plt.figure()
    plt.title(f'{path}')
    for curve, name in zip(curves, names):
        plt.plot(curve['nizo'], curve['hist'], linestyle='-', marker='^', markersize=5, label=f"{name}")
    plt.legend()
    plt.ylabel(r'$\mathcal{F}(\theta)$', fontweight='bold', fontsize=20)
    plt.xlabel('# IZO', fontsize=20)
    plt.show()
    plt.savefig(result_path + f"all_{alg}_1.png")


    plt.figure()
    plt.title(f'{path}')
    for curve, name in zip(curves, names):
        plt.plot(curve['nht'], curve['hist'], linestyle='-', marker='^', markersize=5, label=f"{name}")
    plt.legend()
    plt.ylabel(r'$\mathcal{F}(\theta)$', fontweight='bold', fontsize=20)
    plt.xlabel('# NHT', fontsize=20)
    plt.show()
    plt.savefig(result_path + f"all_{alg}_2.png")

