# Check if required command line arguments are provided
if [ $# -lt 5 ]; then
    echo "Usage: bash script.sh <q_value> <k_value> <dataset>"
    exit 1
fi

q=$1
k=$2
dataset=$3
beta=$4
mu=$5

eta=0.1
lam=0.5
# mu=0.0001
pf=1
bs=1
uf=10
zomax=80000

gd=(0.005 0.01 0.05 0.1 0.5)
# gd=(0.01 0.05)
# gd=(0.05)

shortpath="${dataset}_q_${q}_k_${k}_beta_${beta}_mu_${mu}"
path="./results/${shortpath}"

# algorithms=("szoht" "svrgzoht" "b-svrgzoht" "sarah-zht")
# algorithms=("svrgzoht" "b-svrgzoht")
algorithms=("b-svrgzoht" "sarah-zht")

mkdir "$path"; \
rm "$path/results_mean.csv" ; \
rm "$path/results_std.csv" ; \
rm "$path/it_count.csv" ; \
rm "$path/nizo.csv"; \
rm "$path/nht.csv"

echo "============"
echo $mu
echo "============"

for algorithm in "${algorithms[@]}"
do
    command="python main.py -d $dataset -a $algorithm --nruns 3 --iter 100000000000000000000000 --zomax $zomax --eta $eta --mu $mu --q $q --lam $lam --k $k -B $beta --plot_freq $pf --batch_size $bs --update_freq $uf -t $path -g ${gd[*]}"
    eval "$command"
done
