# Check if required command line arguments are provided
if [ $# -lt 2 ]; then
    echo "Usage: bash script.sh <k_value> <dataset>"
    exit 1
fi




k=$1
dataset=$2

eta=0.1
lam=0.5
mu=0.0001
pf=1
bs=1
uf=10
zomax=1000

gd=(0.005 0.01 0.05 0.1 0.5)

shortpath="${dataset}_k_${k}"
path="./results/${shortpath}"

algorithms=("svrgzoht" "sarah-zht" "saga-zht" "bvrht12" "bvrhtn")

mkdir "$path"; \
rm "$path/results_mean.csv" ; \
rm "$path/results_std.csv" ; \
rm "$path/it_count.csv" ; \
rm "$path/nizo.csv"; \
rm "$path/nht.csv"

for algorithm in "${algorithms[@]}"
do
    command="python main.py -d $dataset -a $algorithm --nruns 3 --iter 100000000000000000000000 --zomax $zomax --eta $eta --mu $mu --lam $lam --k $k --plot_freq $pf --batch_size $bs --update_freq $uf -t $path -g ${gd[*]}"
    eval "$command"
done
