#!/usr/bin/env python
# coding: utf-8

import pickle
import matplotlib.pyplot as plt

with open('./save/szo_curves.pickle', 'rb') as file:
    szoht_curve = pickle.load(file)

with open('./save/vr_curves.pickle', 'rb') as file:
    vrszht_curve = pickle.load(file)

with open('./save/sara_curves.pickle', 'rb') as file:
    sarahcurve = pickle.load(file)

with open('./save/bvr_curves.pickle', 'rb') as file:
    bvrcurve = pickle.load(file)


plt.figure()
for curve, name in zip([vrszht_curve,  szoht_curve, sarahcurve, bvrcurve], ['VR-SZHT',  'SZOHT','SARAH-ZHT', 'BVR-SZHT(ours)']):
    plt.plot(curve['nizo'], curve['hist'], linestyle='-', marker='^', markersize=5, label=f"{name}")
plt.legend()
plt.ylabel(r'$f(\omega)$', fontweight='bold', fontsize=20)
plt.xlabel('IZO', fontsize=20)
# plt.show()
plt.savefig("IZO_bird.png")


plt.figure()
for curve, name in zip([vrszht_curve, szoht_curve, sarahcurve, bvrcurve], ['VR-SZHT', 'SZOHT','SARAH-ZHT', 'BVR-SZHT(ours)']):
    plt.plot(curve['nht'], curve['hist'], linestyle='-', marker='^', markersize=5, label=f"{name}")
plt.legend()
plt.ylabel(r'$f(\omega)$', fontweight='bold', fontsize=20)
plt.xlabel('NHT', fontsize=20)
# plt.show()
plt.savefig("NHT_bird.png")



