##!/bin/bash
## Set the base command with all fixed parameters
BASE_COMMAND="python main.py \
    --x_columns -1 \
    --n_components 0.99 \
    --k_extra 0 \
    --noise_scale_embeddings 0 \
    --device 3 \
    --method none"

# Loop over seeds
for dataset in "yeast" "K562" "K562_scGPT" ; do
  for seed in {0..9}; do
    for num_test in 100; do
      echo "Running experiment with seed=${seed} and num_test=${num_test}"
      # Append the seed and num_test to the base command and execute
      $BASE_COMMAND --seed $seed --num_test $num_test --dataset $dataset 
    done
  done
done

BASE_COMMAND="python main.py \
    --dataset cell_painting \
    --x_columns -1 \
    --n_components 0.99 \
    --k_extra 0 \
    --noise_scale_embeddings 0 \
    --device 3 \
    --method none"

# Loop over seeds
for seed in {0..9}; do
  for num_test in 100; do
    for target_indx in 10 11 12 13 14; do
      echo "Running experiment with seed=${seed}, target index ${target_indx}, and num_test=${num_test}"
      # Append the seed and num_test to the base command and execute
      $BASE_COMMAND --seed $seed --num_test $num_test --target_indx $target_indx
    done
  done
done

#!/bin/bash
# Set the base command with all fixed parameters
BASE_COMMAND="python main.py \
    --x_columns 100 \
    --n_components 0.99 \
    --k_extra 0 \
    --noise_scale_embeddings 0 \
    --device 3 \
    --method none"

# Loop over seeds
for dataset in "yeast" "K562" "K562_scGPT"; do
  for seed in {0..9}; do
    for num_test in 100; do
      echo "Running experiment with seed=${seed} and num_test=${num_test}"
      # Append the seed and num_test to the base command and execute
      $BASE_COMMAND --seed $seed --num_test $num_test --dataset $dataset 
    done
  done
done

BASE_COMMAND="python main.py \
    --dataset cell_painting \
    --x_columns 100 \
    --n_components 0.99 \
    --k_extra 0 \
    --noise_scale_embeddings 0 \
    --device 3 \
    --method none"

# Loop over seeds
for seed in {0..9}; do
  for num_test in 100; do
    for target_indx in 10 11 12 13 14; do
      echo "Running experiment with seed=${seed}, target index ${target_indx}, and num_test=${num_test}"
      # Append the seed and num_test to the base command and execute
      $BASE_COMMAND --seed $seed --num_test $num_test --target_indx $target_indx
    done
  done
done
