#!/bin/bash
# Set the base command with all fixed parameters
BASE_COMMAND="python main.py \
    --dataset K562 \
    --x_columns 1000 \
    --n_components 0.99 \
    --k_extra 0 \
    --noise_scale_embeddings 0 \
    --device 1 \
    --method none \
    --use_random_split 0"

# Loop over seeds
for seed in {1..5}; do
  for num_test in 5 10 15 20 50 100 150; do
    echo "Running experiment with seed=${seed} and num_test=${num_test}"
    # Append the seed and num_test to the base command and execute
    $BASE_COMMAND --seed $seed --num_test $num_test
done
