import numpy as np
from sklearn.linear_model._base import LinearModel

inv = np.linalg.inv

class AnchorRegression(LinearModel):
    def __init__(self, lamb=1, fit_intercept=False, normalize=False, copy_X=False):
        self.lamb = lamb
        self.fit_intercept = fit_intercept
        self.normalize = normalize
        self.copy_X = copy_X

    def fit(self, X, y, A=None):
        #X, y = self._validate_data(X, y, y_numeric=True)

        # Manual preprocessing
        if self.copy_X:
            X = X.copy()
        X_offset = np.mean(X, axis=0)
        y_offset = np.mean(y, axis=0)

        X -= X_offset
        y -= y_offset

        if self.normalize:
            X_scale = np.std(X, axis=0)
            X /= X_scale
        else:
            X_scale = 1.0

        if not isinstance(A, np.ndarray):
            A = A.values

        A = A - A.mean(axis=0)

        P_A = A @ inv(A.T @ A) @ A.T

        self.coef_ = inv(X.T @ X + self.lamb * X.T @ P_A @ X) @ (
            X.T @ y + self.lamb * X.T @ P_A @ y
        )

        self._set_intercept(X_offset, y_offset, X_scale)
        self.is_fitted_ = True
        return self
