import torch
import numpy as np


def evaluate_mse_pearson(Y_pred: torch.Tensor, Y_true: torch.Tensor):

    # Ensure both inputs are 1D tensors of the same shape
    assert Y_pred.ndim == 1 and Y_true.ndim == 1, "Inputs must be 1D tensors."
    assert Y_pred.shape == Y_true.shape, "Tensors must have the same shape."

    # Convert to NumPy arrays for efficient computations
    Y_pred_np = Y_pred.detach().cpu().numpy()
    Y_true_np = Y_true.detach().cpu().numpy()

    # 1) Compute MSE using NumPy
    mse = np.mean((Y_pred_np - Y_true_np) ** 2)

    # 2) Compute Pearson correlation using NumPy's built-in function
    pearson_corr = np.corrcoef(Y_pred_np, Y_true_np)[0, 1]

    return {'mse': mse, 'pearson_corr': pearson_corr}
