import os
import pickle


# Function to save data
def save_results_to_pickle(global_seed,
                           method,
                           hidden_units,
                           dataset,
                           perturbation,
                           noise_scale_embeddings,
                           k_extra,
                           num_test,
                           n_components,
                           epochs,
                           lr,
                           use_random_split,
                           losses,
                           W_ridge,
                           W_sparse,
                           W_lasso,
                           W_true_val,
                           W_true_test,
                           X_test,
                           X_test_approx,
                           X_train_loss,
                           X_test_loss,
                           X_val_loss,
                           target_indx=None):
    """
    Save the results to a pickle file.
    """
    # Convert all tensors to numpy arrays
    results = {
        "losses": losses,
        "W_ridge": W_ridge.cpu().numpy() if W_ridge is not None else None,
        "W_sparse": W_sparse.cpu().numpy() if W_sparse is not None else None,
        "W_lasso": W_lasso.cpu().numpy() if W_lasso is not None else None,
        "W_true_val": W_true_val.cpu().numpy() if W_true_val is not None else None,
        "W_true_test": W_true_test.cpu().numpy() if W_true_test is not None else None,
        "X_test": X_test.cpu().numpy(),
        "X_test_approx": X_test_approx.cpu().numpy() if X_test_approx is not None else None,
        "X_train_loss": X_train_loss,
        "X_test_loss": X_test_loss,
        "X_val_loss": X_val_loss
    }

    # Create the file name
    if dataset == 'synthetic':
        file_name = f"{method}_1_hidden_layer_{hidden_units}_neurons_results_seed_{global_seed}_{dataset}_{target_indx}_{perturbation}_{noise_scale_embeddings}_{k_extra}_{n_components}_{epochs}_{lr}_{use_random_split}.pkl"
    else:
        file_name = f"{method}_1_hidden_layer_{hidden_units}_neurons_results_seed_{global_seed}_{dataset}_{target_indx}_{num_test}_{noise_scale_embeddings}_{k_extra}_{n_components}_{epochs}_{lr}_{use_random_split}.pkl"

    # Save to the root directory
    root_dir = os.path.abspath(os.getcwd())
    file_path = os.path.join(root_dir, file_name)

    # Write to a pickle file
    with open(file_path, "wb") as f:
        pickle.dump(results, f)

    print(f"Results saved to {file_path}")
