 
def load_defauls_plot_style():
    """Setup the default pyplot style for physical review publication figures.
    """
    import matplotlib.pyplot as plt
    from matplotlib import cycler
    mpl_style = {'axes.formatter.use_mathtext': True,
                 'axes.linewidth': 1.0,
                 'axes.prop_cycle': cycler('color', ['#0C5DA5', '#00B945', '#FF9500', '#FF2C00', '#845B97', '#474747', '#9e9e9e']),
                 'figure.figsize': [3.375, 2.5313],
                 'font.family': ['STIXGeneral'],
                 'grid.linewidth': 1.0,
                 'legend.frameon': False,
                 'lines.linewidth': 1.0,
                 'mathtext.fontset': 'stix',
                 'savefig.bbox': 'tight',
                 'savefig.pad_inches': 0.05,
                 'text.latex.preamble': '\\usepackage{amsmath, amssymb}',
                 'text.usetex': False,
                 'xtick.direction': 'in',
                 'xtick.major.size': 3.0,
                 'xtick.major.width': 0.5,
                 'xtick.minor.size': 1.5,
                 'xtick.minor.visible': True,
                 'xtick.minor.width': 0.5,
                 'xtick.top': True,
                 'ytick.direction': 'in',
                 'ytick.major.size': 3.0,
                 'ytick.major.width': 0.5,
                 'ytick.minor.size': 1.5,
                 'ytick.minor.visible': True,
                 'ytick.minor.width': 0.5,
                 'ytick.right': True}
    plt.style.use(mpl_style)
    
# load_defauls_plot_style()

colors = ['#0C5DA5', '#00B945', '#FF9500', '#FF2C00', '#845B97', '#474747', '#9e9e9e']

def nice_points(color):
    return {'color': color, "mfc": get_alpha_hex(color,0.5)}

def hex_to_rgb(value,transmit=None, full=False):
    '''Convert a hex color to rgb tuple.'''
    value = value.lstrip('#')
    lv = len(value)
    step = int(lv/3) 
    scale = 1.0/255.0
    if full:
        scale = 1
    col = tuple(scale*int(value[i:i+step], 16) for i in range(0, lv, step))

    if not transmit:
        return col
    else:
        return col + (transmit,)
def rgb_to_hex(value):
    '''Convert a rgb tuple to a hex color string.'''
    if value[0] < 1:
        scale = 255
    else:
        scale = 1
    rgb = [int(scale*k) for k in value]
    return '#%02x%02x%02x' % (rgb[0],rgb[1],rgb[2]) 

def get_alpha_hex(value,alpha):
    '''Convert a hex color to an equivalent non-transparent version.'''

    #first we get the rgb
    rgb = hex_to_rgb(value)

    # apply the transparency
    target = [alpha*k + (0.999-alpha) for k in rgb] 

    return rgb_to_hex(target)
