# -*- coding: utf-8 -*-


from signatures import *


##############################################################################################
# Experiment: correlation for signatures of OU process (Figure A5 in the appendix)

np.random.seed(0)
random.seed(0)


sig_degree = 4
d = 1
sig_num = calculate_sig_num(sig_degree, d)


kappa_range = np.arange(1e-6, 5, 0.2)

corr_I_list = []
corr_S_list = []
for kappa in kappa_range:
    var_I = T*np.exp(-2*kappa*T) / 4/kappa + 3*np.exp(-4*kappa*T) / 16/kappa**2 - 3* np.exp(-2*kappa*T) / 8/kappa**2 -T/4/kappa + 3/16/kappa**2 + T**2/4
    Exp_I = -1/2 * (T+ (np.exp(-2*kappa*T)-1)/2/kappa)
    corr_I_list.append( Exp_I / np.sqrt(var_I))
    var_S = T*np.exp(-2*kappa*T) / 4/kappa + 3*np.exp(-4*kappa*T) / 16/kappa**2 - 3* np.exp(-2*kappa*T) / 8/kappa**2 -T/4/kappa + 3/16/kappa**2 + T**2/4 - 1/2*T**2 - T*np.exp(-2*kappa*T) / 4 /kappa + T / 4 /kappa + T**2  / 4
    Exp_S = -1/2 * (T+ (np.exp(-2*kappa*T)-1)/2/kappa) + 1/2 *T 
    corr_S_list.append( Exp_S / np.sqrt(var_S))

plt.figure(figsize=(10,5))
plt.plot(kappa_range, np.abs(corr_I_list), label='Itô',markersize=10, markeredgewidth=2, linewidth=2, linestyle='-', markerfacecolor='none', marker="o")
plt.plot(kappa_range, np.abs(corr_S_list), label='Stratonovich',markersize=10, markeredgewidth=2, linewidth=2, linestyle='--', markerfacecolor='none', marker="^")
plt.xlabel("$\\kappa$", fontsize=18)
plt.xticks(fontsize=18)
plt.yticks(fontsize=18)
plt.ylim(-0.05, 1.05)
plt.ylabel("Absolute Values of Corr", fontsize=18)
plt.grid()
plt.legend(fontsize=18, loc="lower right")
plt.savefig('Figure_A5a.pdf', bbox_inches = 'tight' , dpi=150, pad_inches = 0.05)




sample_num = 1000
path_length = 100
T = 1

deltat = 1/path_length
sqrt_deltat = np.sqrt(1/path_length)


corr_I_list = []
corr_S_list = []

kappa_range = np.arange(0, 5.1, 0.5)

for kappa in kappa_range:
    print(kappa)
    
    
    signature_list_I = pd.DataFrame(np.zeros((sample_num, sig_num)))
    signature_list_S = pd.DataFrame(np.zeros((sample_num, sig_num)))
    
    
    for i in range(sample_num):
        # OU
        Z1_list = (np.random.randn(path_length)) * sqrt_deltat
        for l in range(1,len(Z1_list)):
            Z1_list[l] =  Z1_list[l-1] - kappa * Z1_list[l-1] * deltat + Z1_list[l]
        
        Zi_list = np.array([Z1_list]).T
        Wi_list = Zi_list
        
        X_all = Wi_list
        
        
        signature_I = calculate_signature_to_K(X_all, sig_degree, method="Ito")
        signature_list_I.loc[i,:] = signature_I
        signature_S = calculate_signature_to_K(X_all, sig_degree, method="S")
        signature_list_S.loc[i,:] = signature_S
    
    # standardize
    X_list_I = np.array(signature_list_I)
    X_list_I = X_list_I / np.sqrt(np.sum(X_list_I**2, axis=0)) 
    X_list_S = np.array(signature_list_S)
    X_list_S = X_list_S / np.sqrt(np.sum(X_list_S**2, axis=0)) 
    
    
    corr_I = calculate_sample_corr_matrix(X_list_I)
    corr_S = calculate_sample_corr_matrix(X_list_S)
    
    corr_I_list.append(corr_I)
    corr_S_list.append(corr_S)



plt.figure(figsize=(10,5))
plt.plot(kappa_range, [np.abs(corr_I[0,2]) for corr_I in corr_I_list], label="corr($S(X)_t^0, S(X)_t^{1,1}$)", linestyle='-',  markersize=10, markeredgewidth=2, linewidth=2, markerfacecolor='none', marker="o", color="tab:blue")
plt.plot(kappa_range, [np.abs(corr_S[0,2]) for corr_S in corr_S_list], linestyle='--', markerfacecolor='none', marker="^", markersize=10, markeredgewidth=2, linewidth=2, color="tab:blue")
plt.plot(kappa_range, [np.abs(corr_I[0,4]) for corr_I in corr_I_list], label="corr($S(X)_t^0, S(X)_t^{1,1,1,1}$)", linestyle='-',  markersize=10, markeredgewidth=2, linewidth=2, markerfacecolor='none', marker="o", color="tab:orange")
plt.plot(kappa_range, [np.abs(corr_S[0,4]) for corr_S in corr_S_list], linestyle='--', markerfacecolor='none', marker="^", markersize=10, markeredgewidth=2, linewidth=2, color="tab:orange")
plt.plot(kappa_range, [np.abs(corr_I[2,4]) for corr_I in corr_I_list], label="corr($S(X)_t^{1,1}, S(X)_t^{1,1,1,1}$)", linestyle='-', markersize=10, markeredgewidth=2, linewidth=2,  markerfacecolor='none', marker="o", color="tab:green")
plt.plot(kappa_range, [np.abs(corr_S[2,4]) for corr_S in corr_S_list], linestyle='--', markerfacecolor='none', marker="^",markersize=10, markeredgewidth=2, linewidth=2,  color="tab:green")
plt.plot(kappa_range, [np.abs(corr_I[1,3]) for corr_I in corr_I_list], label="corr($S(X)_t^{1}, S(X)_t^{1,1,1}$)", linestyle='-',  markersize=10, markeredgewidth=2, linewidth=2, markerfacecolor='none', marker="o", color="tab:red")
plt.plot(kappa_range, [np.abs(corr_S[1,3]) for corr_S in corr_S_list], linestyle='--', markerfacecolor='none', marker="^",markersize=10, markeredgewidth=2, linewidth=2,  color="tab:red")

plt.legend(fontsize=18, loc="lower right")
plt.xlabel("$\\kappa$", fontsize=18)
plt.xticks(fontsize=18)
plt.yticks(fontsize=18)
plt.ylim(-0.05, 1.05)
plt.ylabel("Absolute Values of Corr", fontsize=18)
plt.grid()
plt.savefig('Figure_A5b.pdf', bbox_inches = 'tight' , dpi=150, pad_inches = 0.05)
    

