# -*- coding: utf-8 -*-


from signatures import *


##############################################################################################
# Experiment: Brownian motion (Figure 1a in the main paper)

np.random.seed(0)
random.seed(0)

sig_degree = 4
d = 2
T = 1

rho = 0.6
Omega = np.array([[1, rho], [rho, 1]])

Ito_6 = calculate_corr_by_formula(Omega, T, d, sig_degree, method="Ito")
pd.DataFrame(Ito_6).to_csv('Figure_A1.csv')


S_6 = calculate_corr_by_formula(Omega, T, d, sig_degree, method="S")
pd.DataFrame(S_6).to_csv('Figure_A3.csv')


rho = 0
Omega = np.array([[1, rho], [rho, 1]])

Ito_0 = calculate_corr_by_formula(Omega, T, d, sig_degree, method="Ito")
pd.DataFrame(Ito_0).to_csv('Figure_A2.csv')


S_0 = calculate_corr_by_formula(Omega, T, d, sig_degree, method="S")
pd.DataFrame(S_0).to_csv('Figure_A4.csv')

