# -*- coding: utf-8 -*-


from signatures import *


##############################################################################################
# Experiment: time augmentation (Figures A10-A11 in the appendix)

np.random.seed(0)
random.seed(0)

sample_num = 10000
sig_degree = 4
d = 1
sig_num = calculate_sig_num(sig_degree, d+1)
path_length = 100
T = 1


signature_list_I = pd.DataFrame(np.zeros((sample_num, sig_num)))
signature_list_S = pd.DataFrame(np.zeros((sample_num, sig_num)))



for i in range(sample_num):
    # BM
    Z1_list = np.cumsum(np.random.randn(path_length)) * np.sqrt(1/path_length)
    W1_list = Z1_list
    
    time_list = np.cumsum(np.ones(path_length) * np.sqrt(1/path_length)) 
        
    X_all = np.array([time_list, W1_list]).T
    
    signature_I = calculate_signature_to_K(X_all, sig_degree, method="Ito")
    signature_list_I.loc[i,:] = signature_I
    signature_S = calculate_signature_to_K(X_all, sig_degree, method="S")
    signature_list_S.loc[i,:] = signature_S

# standardize
X_list_I = np.array(signature_list_I)
X_list_I = X_list_I / np.sqrt(np.sum(X_list_I**2, axis=0)) 
X_list_S = np.array(signature_list_S)
X_list_S = X_list_S / np.sqrt(np.sum(X_list_S**2, axis=0)) 

corr_I = calculate_sample_corr_matrix(X_list_I)
corr_S = calculate_sample_corr_matrix(X_list_S)

pd.DataFrame(corr_I).to_csv('Figure_A10.csv')
pd.DataFrame(corr_S).to_csv('Figure_A11.csv')