# -*- coding: utf-8 -*-


from signatures import *


##############################################################################################
# Experiment: ARIMA-impact of p (Figure A15a in the appendix)

np.random.seed(0)
random.seed(0)

random_experi_num = 1000
sample_num = 100
sig_degree = 3
#d = 2
path_length = 100
T = 1


import numpy as np
import statsmodels.api as sm

rho = 0.2
d = 2
true_factor_num = 4


AR_range = range(1, 11)
#MA_range = range(1, 11)
I_range = [0,1,2,3]
MA = 1


correct_rate_I_list = pd.DataFrame(columns=AR_range, index=I_range)
correct_rate_S_list = pd.DataFrame(columns=AR_range, index=I_range)
avg_max_precision_I_list = pd.DataFrame(columns=AR_range, index=I_range)
avg_max_precision_S_list = pd.DataFrame(columns=AR_range, index=I_range)
avg_max_recall_I_list = pd.DataFrame(columns=AR_range, index=I_range)
avg_max_recall_S_list = pd.DataFrame(columns=AR_range, index=I_range)
avg_max_F1_I_list = pd.DataFrame(columns=AR_range, index=I_range)
avg_max_F1_S_list = pd.DataFrame(columns=AR_range, index=I_range)

for I in I_range:
    sig_num = calculate_sig_num(sig_degree, d)
    select_result_I_list = pd.DataFrame(columns=AR_range, index=range(random_experi_num))
    select_result_S_list = pd.DataFrame(columns=AR_range, index=range(random_experi_num))
    max_precision_I_list = pd.DataFrame(columns=AR_range, index=range(random_experi_num))
    max_precision_S_list = pd.DataFrame(columns=AR_range, index=range(random_experi_num))
    max_recall_I_list = pd.DataFrame(columns=AR_range, index=range(random_experi_num))
    max_recall_S_list = pd.DataFrame(columns=AR_range, index=range(random_experi_num))
    max_F1_I_list = pd.DataFrame(columns=AR_range, index=range(random_experi_num))
    max_F1_S_list = pd.DataFrame(columns=AR_range, index=range(random_experi_num))
    
    for AR in AR_range:
    
        rho1 = rho
        
        Omega = np.ones((d, d)) * rho1
        for temp in range(d):
            Omega[temp,temp] = 1
        Chole_factor = np.linalg.cholesky(Omega).T
        
        
        for exp in range(random_experi_num):
            print(AR, exp)
            signature_list_I = pd.DataFrame(np.zeros((sample_num, sig_num)))
            signature_list_S = pd.DataFrame(np.zeros((sample_num, sig_num)))
            
            
            
            beta_location = random.sample(range(sig_num), true_factor_num)
            beta_values = np.random.randn(true_factor_num)
            
            
            for i in range(sample_num):
                # BM
                Zi_list = []
                
                for temp in range(d):
                    # The AR and MA parameters
                    ar_params = np.random.randn(AR) / 100
                    ma_params = np.random.randn(MA) / 100
                    
                    # Include zero-lag
                    ar_params = np.r_[1, -ar_params]
                    ma_params = np.r_[1, ma_params]
                    
                    arima_process = sm.tsa.ArmaProcess(ar_params, ma_params)
                    simulated_process = arima_process.generate_sample(nsample=path_length)
                
                    # Integrate the series three times
                    for _ in range(I):
                        simulated_process = np.cumsum(simulated_process)
                
                

                    Zi_list.append( simulated_process )
                
                Zi_list = np.array(Zi_list).T
                Wi_list = Zi_list @ Chole_factor
                
                X_all = Wi_list
                
                signature_I = calculate_signature_to_K(X_all, sig_degree, method="Ito")
                signature_list_I.loc[i,:] = signature_I
                signature_S = calculate_signature_to_K(X_all, sig_degree, method="S")
                signature_list_S.loc[i,:] = signature_S
                
            
            # standardize
            X_list_I = np.array(signature_list_I)
            X_list_I = X_list_I / np.sqrt(np.sum(X_list_I**2, axis=0)) 
            X_list_S = np.array(signature_list_S)
            X_list_S = X_list_S / np.sqrt(np.sum(X_list_S**2, axis=0)) 
            
            y_list_I =  X_list_I[:,beta_location] @ beta_values + np.random.randn(sample_num)*np.sqrt(0.0001)
            y_list_S =  X_list_S[:,beta_location] @ beta_values + np.random.randn(sample_num)*np.sqrt(0.0001)
            
            _, _, coefs_I = linear_model.lars_path(X_list_I, y_list_I, method="lasso", verbose=True)
            _, _, coefs_S = linear_model.lars_path(X_list_S, y_list_S, method="lasso", verbose=True)
            
            
            select_result_I = check_Lasso_select_result(coefs_I, beta_location, beta_values)
            select_result_S = check_Lasso_select_result(coefs_S, beta_location, beta_values)
        
            select_result_I_list.loc[exp, AR] = select_result_I
            select_result_S_list.loc[exp, AR] = select_result_S
            
            max_precision_I, max_recall_I, max_F1_I = check_Lasso_confusion_matrix(coefs_I, beta_location, beta_values)
            max_precision_S, max_recall_S, max_F1_S = check_Lasso_confusion_matrix(coefs_S, beta_location, beta_values)
        
            max_precision_I_list.loc[exp, AR] = max_precision_I
            max_precision_S_list.loc[exp, AR] = max_precision_S
            max_recall_I_list.loc[exp, AR] = max_recall_I
            max_recall_S_list.loc[exp, AR] = max_recall_S
            max_F1_I_list.loc[exp, AR] = max_F1_I
            max_F1_S_list.loc[exp, AR] = max_F1_S
        
    
    correct_rate_I = np.sum(select_result_I_list, axis=0) / random_experi_num
    correct_rate_S = np.sum(select_result_S_list, axis=0) / random_experi_num
    
    correct_rate_I_list.loc[I, :] = correct_rate_I
    correct_rate_S_list.loc[I, :] = correct_rate_S
    
    max_precision_I = np.sum(max_precision_I_list, axis=0) / random_experi_num
    max_precision_S = np.sum(max_precision_S_list, axis=0) / random_experi_num
    
    avg_max_precision_I_list.loc[I, :] = max_precision_I
    avg_max_precision_S_list.loc[I, :] = max_precision_S
    
    max_recall_I = np.sum(max_recall_I_list, axis=0) / random_experi_num
    max_recall_S = np.sum(max_recall_S_list, axis=0) / random_experi_num
    
    avg_max_recall_I_list.loc[I, :] = max_recall_I
    avg_max_recall_S_list.loc[I, :] = max_recall_S
    
    max_F1_I = np.sum(max_F1_I_list, axis=0) / random_experi_num
    max_F1_S = np.sum(max_F1_S_list, axis=0) / random_experi_num
    
    avg_max_F1_I_list.loc[I, :] = max_F1_I
    avg_max_F1_S_list.loc[I, :] = max_F1_S
    
    correct_rate_I_list.to_csv('Experiment_15a_correct_rate_I.csv')
    correct_rate_S_list.to_csv('Experiment_15a_correct_rate_S.csv')
    avg_max_precision_I_list.to_csv('Experiment_15a_avg_max_precision_I.csv')
    avg_max_precision_S_list.to_csv('Experiment_15a_avg_max_precision_S.csv')
    avg_max_recall_I_list.to_csv('Experiment_15a_avg_max_recall_I.csv')
    avg_max_recall_S_list.to_csv('Experiment_15a_avg_max_recall_S.csv')
    avg_max_F1_I_list.to_csv('Experiment_15a_avg_max_F1_I.csv')
    avg_max_F1_S_list.to_csv('Experiment_15a_avg_max_F1_S.csv')





###########################


data_I = pd.read_csv('Experiment_15a_correct_rate_I.csv', index_col=0)
data_S = pd.read_csv('Experiment_15a_correct_rate_S.csv', index_col=0)

data_I.columns = [float(x) for x in data_I.columns]
data_S.columns = [float(x) for x in data_S.columns]

plt.figure(figsize=(9.5,5))

linecolor = ['tab:blue', 'tab:orange', 'tab:green', 'tab:red']

for i in range(np.shape(data_I)[0]-1):
    data = data_I.iloc[i+1,:]
    plt.plot(data, marker="o", markersize=10, markeredgewidth=2, linewidth=2, markerfacecolor='none',linestyle="-",color=linecolor[i],label='$I=$'+str(data_I.index[i+1]))
for i in range(np.shape(data_S)[0]-1):
    data = data_S.iloc[i+1,:]
    plt.plot(data, marker="^", markersize=10, markeredgewidth=2, linewidth=2, markerfacecolor='none',linestyle="--",color=linecolor[i])

plt.legend(fontsize=20, loc="upper right")
plt.xlabel("$p$ (lag of AR)", fontsize=20)
plt.xticks(fontsize=20)
plt.yticks(fontsize=20)
plt.ylim(-0.05, 1.05)
#plt.xlim(-1, 1)
plt.ylabel("Consistency Rate", fontsize=20)
plt.grid()
plt.savefig('Figure_15a.pdf', bbox_inches = 'tight' , dpi=150, pad_inches = 0.05)