import torch
import numpy as np

from torch import Tensor

# Broadcasting 2-norm squared cost
def eucl_norm_sq(x : Tensor, y : Tensor, squeeze = False):
    new_view_x = x.view(1,1,-1) if x.dim() < 2 \
        else x.unsqueeze(1)

    new_view_y = y.view(1,1,-1) if y.dim() < 2 \
        else y.unsqueeze(0)

    norm_sq = 0.5 * (new_view_x - new_view_y).square().sum(-1)

    return norm_sq.squeeze() if squeeze else norm_sq

# Non pairwise broadcasting 2-norm squared cost
def eucl_norm_sq_nb(x : Tensor, y : Tensor):
    return 0.5 * (x - y).square().sum(-1)

def np_eucl_norm_sq(x : np.ndarray, y : np.ndarray):
    new_view_x = np.expand_dims(np.atleast_2d(x), axis = 1)
    new_view_y = np.expand_dims(np.atleast_2d(y), axis = 0)

    return np.sum(np.square(new_view_x-new_view_y), -1) / 2.0

def np_eucl_norm_sq_grad(x : np.ndarray,y : np.ndarray):
    new_view_x = np.expand_dims(np.atleast_2d(x), axis = 1)
    new_view_y = np.expand_dims(np.atleast_2d(y), axis = 0)

    return new_view_x - new_view_y
