import numpy as np
import torch

from torch import Tensor
from typing import Union

def projection_to_zero_mean(tensor : Tensor) -> Tensor:
    """Implements a projection onto linear subspace of tensors with zero mean
    """
    return tensor - torch.sum(tensor) / tensor.numel()

def copy_to_tensor(arr_tocon : Union[np.ndarray, Tensor]) -> Tensor:
    """A convenience from to produce a copied tensor from either a numpy array or
       tensor
    """

    return torch.from_numpy(array).clone() if \
           type(array) is np.ndarray else \
           array.detach().clone()
