# Supplemental Video Material for "Learning to Control Free-Form Soft Swimmers"

## Forward Swimming Task

#### Main Results (Three methods comparison)

<video src=".\main_results.mp4"></video>

Note: We have found that for the clownfish model, the original Domain-expert design of two muscles leads to imbalanced motion, due to the asymmetry of the model. So we further test the design of four muscles. The resultant motion is similar to that of our method.

For the eel model, the original muscle distribution of domain-expert controller performs poorly, so we optimize the location and length of the muscle and it can achieve a competetive forward speed.



#### More results

Models below don't have domain-expert actuation design. We compare the reuslts of our method and clustering-based controllers.

<video src=".\more_results.mp4"></video>



There are some cases where both our method and the baseline can't provide effective control strategies.

<video src=".\hard_cases.mp4"></video>

#### 

## Advanced Locomotion Task: Navigation



Trained poilcy for the navigation task. including our method, clustering-based controller and domain-expert controller. 



<video src=".\navigation3d.mp4"></video>



## Validation on a 2D fish-like model



The trained policy in our framework for 2d fish-like model. Tasks include forward swimming and navigation.

<video src=".\fish2d.mp4"></video>



## Differentiable Controller



The differentiable controller pipeline (implemented by SoftZoo, see https://github.com/zswang666/softzoo) currently supports optimizations within approximately 2 seconds of simulated duration, as extended temporal scales frequently induce numerical instabilities. When scaling objects to dimensions similar to our experimental settings and applying optimization processes to forward swimming tasks across multiple models, we observed several critical phenomena. As shown in the videos, the optimized structures exhibited minimal characteristic deformations, instead manifesting high-frequency oscillations accompanied by systemic physical instability - particularly visible through fluid particles being transported beyond computational domains during simulations. Please note: The right side of the video indicates the task-specified direction of motion, and we slow down the video time to 5 seconds to show the motions more clearly.



<video src=".\softzoo.mp4"></video>

<video src=".\softzoo.mp4"></video>