#!/usr/bin/env python3

import os
import subprocess
import sys
import time

# Model names and rhyme family pairs from the original script
MODEL_NAMES = [
    "Gemma2_9B",
    "Gemma2_27B",
    "Gemma3_1B",
    "Gemma3_4B",
    "Gemma3_12B",
    "Gemma3_27B",
    "Llama3.2_3B",
    "Llama3.1_8B",
    "Qwen3_8B",
    "Qwen3_14B",
    "Qwen3_32B",
    "Gemma2_9B_Base",
    "Gemma2_27B_Base",
    "Gemma3_1B_Base",
    "Gemma3_4B_Base",
    "Gemma3_12B_Base",
    "Gemma3_27B_Base",
    "Llama3.2_3B_Base",
    "Llama3.1_8B_Base",
    "Qwen3_8B_Base",
    "Qwen3_14B_Base",
    "Qwen3_32B_Base",
    "Llama3.3_70B",
    "Llama3.3_70B_Base",
]


def run_filter_suggestiveness(model_name):
    script_path = os.path.join(os.path.dirname(__file__), "filter_suggestiveness.py")

    cmd = [
        sys.executable,
        script_path,
        "--model_name",
        model_name,
    ]

    print(f"Running: {' '.join(cmd)}")
    start_time = time.time()

    try:
        # Run without capturing output so we see it in real-time
        result = subprocess.run(cmd, check=True)
        elapsed = time.time() - start_time
        print(f"✓ Completed in {elapsed:.1f}s")
        return True
    except subprocess.CalledProcessError as e:
        elapsed = time.time() - start_time
        print(f"✗ Failed after {elapsed:.1f}s")
        print(f"Error: {e}")
        return False


def main():
    for model_name in MODEL_NAMES:
        run_filter_suggestiveness(model_name)


if __name__ == "__main__":
    main()
