# Code:

src/ contains all code for training and computing the schedule deviation
src/low\_dim.py contains the code for the low-dimensional experiments
vendor/ contains a maze generation library, othogonal to the core code

## Installing

Install the needed packages using UV (https://github.com/astral-sh/uv)
We have provided a lockfile to use with uv.

```bash
   uv sync --dev
```

Next instantiate the datasets using the ``nd" tool. For instance, for the datasets in the paper, use,
``
  uv run nd pull fashion-mnist hf://zalando-datasets/fashion\_mnist -t "deviation_metric.data.tsne\_image" -m "data/image+class+tsne"
  uv run nd pull mnist hf://ylecun/mnist -t "deviation_metric.data.tsne\_image" -m "data/image+class+tsne"
''
This will both download the dataset locally and tsne the data.

## Running

You can then run training script using (for instance)
```bash
   uv run train --data mnist --wandb
   uv run train --data fashion_mnist --wandb
   uv run train --data trajectory --wandb
```
Note that this requires a weights and biases account.
We can then evaluate metrics like schedule inconsistency for a particular checkpoint using
```bash
   uv run metrics --wandb --batch_size 128 --num_samples 5_000 --artifact <WANDB MODEL ARTIFACT ID>
```
