import argparse

def arg_parse():
    parser = argparse.ArgumentParser(description='GcnInformax Arguments.')
    parser.add_argument('--train-num', dest='train_num', type=int, default=5000)
    #parser.add_argument('--multi-target', dest='multi_target', type=str, help='')
    parser.add_argument('--use-unsup-loss', dest='use_unsup_loss', action='store_const', const=True, default=False)
    parser.add_argument('--separate-encoder', dest='separate_encoder', action='store_const', const=True, default=False)

    parser.add_argument('--lr', dest='lr', type=float, default=0.01,
            help='Learning rate.')
    parser.add_argument('--lamda', dest='lamda', type=float, default=0.001,
            help='for balancing supervised and unsupervised loss')
    parser.add_argument('--weight-decay', dest='weight_decay', type=float, default=0,
            help='')
    # parser.add_argument('--', dest='num_gc_layers', type=int, default=5,
            # help='Number of graph convolution layers before each pooling')
    # parser.add_argument('--hidden-dim', dest='hidden_dim', type=int, default=32,
            # help='')

    parser.add_argument('--eps', type=float, default=0.0001, help='sparsify generated diffusion matrix')
    # for IGSD
    parser.add_argument('--device', type=str, default='cuda')
    parser.add_argument('--dataset', type=str, default='QM9')
    parser.add_argument('--aug_type', type=str, default='diff', help='random or diff or TODO')
    parser.add_argument('--drop_prob', type=float, default=0.5)
    parser.add_argument('--projection_hidden_size', type=int, default=2048)
    parser.add_argument('--projection_size', type=int, default=512)
    parser.add_argument('--num_layer', type=int, default=4)
    parser.add_argument('--hid_dim', type=int, default=256)

    parser.add_argument('--target', type=int, default=0, help='for semi-supervised target property regression')
    parser.add_argument('--batch_size', type=int, default=4, help='for semi-supervised training')
    parser.add_argument('--num_epoch', type=int, default=400, help='for semi-supervised training')

    parser.add_argument('--unsup_times', type=float, default=1, help='sparsify generated diffusion matrix')

    return parser.parse_args()

args = arg_parse()

#if __name__ == '__main__':
#    args = arg_parse()
#    print(args)
