import argparse

parser = argparse.ArgumentParser()
parser.add_argument('--device', type=str, default='cuda')
parser.add_argument('--dataset', type=str, default='REDDIT-BINARY')
parser.add_argument('--model', type=str, default='igsd')
parser.add_argument('--aug_type', type=str, default='diff',help='random or diff or TODO')
parser.add_argument('--drop_prob', type=float, default=0.5)
parser.add_argument('--projection_hidden_size', type=int, default=2048)
parser.add_argument('--projection_size', type=int, default=256)
parser.add_argument('--predict_size', type=int, default=128)

# add negative samples
parser.add_argument('--use-neg-loss', dest='use_neg_loss', action='store_const', const=True, default=False)
parser.add_argument('--neg_times', type=int, default=0)
parser.add_argument('--alpha', type=float, default=0.3)
parser.add_argument('--beta', type=float, default=1.0)
parser.add_argument('--neg_prob', type=float, default=1.0)
# ablation
parser.add_argument('--ablation_batch', type=int, default=0)

# NOTE: below is for semi-supervised graph classification
parser.add_argument('--test_ratio', type=float, default=0.1)
parser.add_argument('--valid_ratio', type=float, default=0.1)
parser.add_argument('--train_ratio', type=float, default=0.1, help='ratio of labeled training set (in QM9, 0.05)')
parser.add_argument('--unsup_ratio', type=float, default=0.8)

args = parser.parse_args()
if args.unsup_ratio != 1-args.test_ratio-args.valid_ratio:
    print("Warning: the train/val/test ratios are not specified properly")