import torch


class Config:

    device = "cuda" if torch.cuda.is_available() else "cpu"

    # YOLO
    yolo_model = "yolo11l.pt"
    conf_threshold = 0.25

    # FSRCNN
    fsrcnn_model = "_artifacts/pretrained/fsrcnn_x4-T91-97a30bfb.pth.tar"
    scaling_factor = 4

    # Stereo Camera calibration file
    calib_json = "calibration.json"

    # Stereo Camera params (only used if calib_json == "")
    focal_len_pix = 1004 # First value in projection matrix
    baseline = 0.548 # Euclidean dist. b/w translation vectors of both cameras
