# OptiRSDE

**Optimized Robust Stereo Depth Estimation**

A novel approach with temporal smoothing and optimized feature matching for fast and robust depth estimation.

## Environment

This code has been tested in the following environment:  
- Python 3.12
- CUDA 12.6
- Linux Mint 22.1 'Xia'
- AMD Ryzen 5 4600H + 8GB RAM
- NVIDIA GeForce GTX 1650 Ti 4GB VRAM

## How to run

1. Clone this repository.

2. Install all the dependencies.  
    ```sh
    pip install -r requirements.txt
    ```

3. Edit the `config.py` file and put in the appropriate values.

4. Run `image_inf.py` as following:  
    ```sh
    python image_inf.py <left> <right> -o <output>
    ```  
    where the arguments are the path to the left stereo image, right stereo image and the output image respectively.

`video_inf.py` can be run in a similar fashion for videos.  

**Note:** Run `python <script>.py -h` to display the arguments for any \<script>.py

## Camera Calibration

To calibrate using a set of stereo images, use the script `calibrate.py`. All its configuration is inside its `main` function.

To calibrate using a pair of stereo videos, use the script `e2evid.py`. Following command will print the usage instructions:
```sh
python -m scripts.e2evid -h
```
Configuration of the calibration procedure is at the top of the script and can be modified there.
