import torch


class Config:
    device = "cuda" if torch.cuda.is_available() else "cpu"

    # Stereo Camera calibration file
    calib_json = "calibration.json"

    # Stereo Camera params (only used if calib_json == "")
    focal_len_pix = 1004  # First value in projection matrix
    baseline = 0.548  # Euclidean dist. b/w translation vectors of both cameras

    # YOLO
    yolo_model = "yolo11l.pt"
    conf_threshold = 0.25

    # Keypoint detector name [An HF model or "brisk"]
    kp_detector_name = "brisk"  # or "magic-leap-community/superglue_outdoor"

    # Match distance threshold (not used for DL-based KP detectors)
    match_dist_thr = 50.0

    # Keypoint detection region factor
    kp_region_factor = 1.0
