# mmseg/datasets/brats_voc.py
from .voc import PascalVOCDataset
from mmseg.registry import DATASETS

@DATASETS.register_module()
class BRATSVOCDataset(PascalVOCDataset):
    METAINFO = dict(
        classes=('background', 'brain'),
        palette=[[0, 0, 0], [255, 255, 255]]  
    )

    def __init__(self, **kwargs):
        super().__init__(
            img_suffix='.png',
            seg_map_suffix='.png',
            **kwargs
        )

print("✅ BRATSVOCDataset loaded.")
