# mmseg/datasets/transforms/resize_to_original.py

from mmcv.transforms import BaseTransform
from mmseg.registry import TRANSFORMS

@TRANSFORMS.register_module()
class ResizeToOriginalSize(BaseTransform):
    """Resize prediction back to original image size."""
    def transform(self, results):
        ori_shape = results['ori_shape'][:2]
        results['img'] = results['img'][:, :ori_shape[0], :ori_shape[1]]
        if 'seg_fields' in results and results['seg_fields']:
            for key in results['seg_fields']:
                results[key] = results[key][:ori_shape[0], :ori_shape[1]]
        return results
    
print("✅ ResizeToOriginalSize 注册成功")

