import os
import cv2
import numpy as np

# 输入和输出路径
mask_dir = '/path_to_your_dataset/png_masks'  # 替换为标注文件夹路径
output_dir = '/path_to_your_dataset/processed_masks'  # 替换为输出文件夹路径
os.makedirs(output_dir, exist_ok=True)

# 遍历所有标注文件
for mask_file in os.listdir(mask_dir):
    mask_path = os.path.join(mask_dir, mask_file)
    mask = cv2.imread(mask_path, cv2.IMREAD_GRAYSCALE)
    
    # 将所有非0值归为1
    processed_mask = np.where(mask > 0, 1, 0).astype(np.uint8)
    
    # 保存预处理后的文件
    output_path = os.path.join(output_dir, mask_file)
    cv2.imwrite(output_path, processed_mask)

print("Mask preprocessing complete. Processed masks saved in:", output_dir)
