from mmseg.registry import MODELS
import torch.nn as nn
import torch.nn.functional as F
import torch

@MODELS.register_module()
class Dka(nn.Module):
    def __init__(self, input_dim, middle_dim=192):
        super(Dka, self).__init__()
        self.adapter_down = nn.Linear(input_dim, middle_dim, bias=False)
        self.adapter_up = nn.Linear(middle_dim, input_dim, bias=False)
        self.conv1 = nn.Conv2d(middle_dim, middle_dim, kernel_size=51, stride=1, padding=25, groups=middle_dim, bias=False)
        self.conv2 = nn.Conv2d(middle_dim, middle_dim, kernel_size=3, stride=1, padding=1, groups=middle_dim, bias=False)
        self.act = F.gelu
        self.dropout = nn.Dropout(0.1)

    def forward(self, x, hw_shape):
        B, N, C = x.shape  # (batch, seq_len, embed_dim)
        H, W = hw_shape
        x_down = self.adapter_down(x)  # (B, N, reduced_dim)
        x_down = self.act(x_down)
        x_patch = x_down[:, 1:].reshape(B, H, W, -1).permute(0, 3, 1, 2)  
        conv1_out = self.conv1(x_patch)  
        conv2_out = self.conv2(x_patch)  
        x_patch = conv1_out + conv2_out  
        x_patch = x_patch.permute(0, 2, 3, 1).reshape(B, H * W, -1)  
        x_cls = x_down[:, :1]  
        x_down = torch.cat([x_cls, x_patch], dim=1)  
        x_down = self.act(x_down)
        x_down = self.dropout(x_down)
        x_up = self.adapter_up(x_down)  

        return x + x_up 
