# HW-GPT-Bench results
## Reproduce Results
The code uses [Celery](https://docs.celeryq.dev) to distribute neural networks to workers that can be launched on 
different machines.

To reproduce the results given in the paper proceed as follows:

1. Install the HW-GPT-Bench library from: https://github.com/automl/HW-GPT-Bench.

2. [Install a redis server](https://redis.io/docs/latest/operate/oss_and_stack/install/install-redis/install-redis-on-linux/) 
that will be used as a broker for Celery.

3. Start the redis server and use the redis-cli to set a password with the command `CONFIG SET requirepass newpassword`.

5. Change the broker url in `HWGPTBench_celery.py` from `redis://:Xcrdb3rDeEf@172.31.55.178:27010/` 
to your own password, ip, and port.

6. Use the command `celery -A HWGPTBench_celery worker --loglevel=INFO` on all machines you want to
use. By default, it will spawn as many workers as the machines have cores.

7. To distribute the tasks to the workers you can use the following code:
    ```python3
    from HWGPTBench_celery import *
    import json

    idx2arch = {}
    for i in range(20_000):
        arch = api.sample_arch()
        idx2arch[i] = arch
        train.delay(arch, i)

    with open("idx_2_arch.json", "w") as f:
        json.dump(idx2arch, f)
    ```

8. The results for each network are stored in separate files. You can combine them by running:
    ```python3
    import glob
    import re

    stats = {}
    for filename in glob.glob("*.json"):
        model_id = re.findall(r"\d+", filename)[0]
        with open(filename) as f:
            stats[model_id] = json.load(f)
    ```

9. Use the script [correlation.py](results/correlation.py) to calculate the Spearman's rho and Kendall's tau coefficients.

## Copyright Notice
To allow a fair comparison with proxies from the literature, we use code from previous publications. 
The adaptations made are for the sole purpose of integrating the code into our software.
Please note the copyright and license at the top of each file.

* [meco.py](proxies/meco.py) is adapted from Ref. 1 and licensed under the MIT license

[1] T. Jiang, H. Wang, and R. Bie, 
    MeCo: Zero-shot NAS with one data and single forward pass via minimum eigenvalue of correlation, 
    in Adv. Neural Inf. Process. Syst., Vol. 36 (2023) pp. 61020–61047.