# NAS-Benchmarks
## Reproduce Results
The code uses [Celery](https://docs.celeryq.dev) to distribute neural networks to workers that can be launched on 
different machines.

To reproduce the results given in the paper proceed as follows:

1. Install the requirements listed in [requirements.txt](requirements.txt) by running `pip install -r requirements.txt`.

2. [Install a redis server](https://redis.io/docs/latest/operate/oss_and_stack/install/install-redis/install-redis-on-linux/) 
that will be used as a broker for Celery.

3. Start the redis server and use the redis-cli to set a password with the command `CONFIG SET requirepass newpassword`.

5. Change the broker url in `NATSBench_celery.py` from `redis://:Xcrdb3rDeEf@172.31.55.178:27010/` 
to your own password, ip, and port.

6. Use the command `celery -A NATSBench_celery worker --loglevel=INFO` on all machines you want to
use. By default, it will spawn as many workers as the machines have cores.

7. To distribute the tasks to the workers you can use the following code:
    ```python3
    # for NATS-Bench
    from NATSBench_celery import *

    for model_id in range(15625):
        train.delay(model_id)
    ```

9. The results for each network are stored in separate files. You can combine them by running:
    ```python3
    import glob
    import re

    stats = {}
    for filename in glob.glob("*.json"):
        model_id = re.findall(r"\d+", filename)[0] # for NATS-Bench
        with open(filename) as f:
            stats[model_id] = json.load(f)
    ```

10. Use the script [correlation_per_layer.py](correlation_per_layer.py) to calculate the average ranking per layer.

11. Use the script [plot.py](plot.py) to reproduce figure A.7.