#!/usr/bin/env python3

import re
import numpy as np
import scipy
import ast
from collections import defaultdict

seeds = range(1234, 1254)
activation_functions = ["SiLU", "ReLU", "Tanh", "Tanhshrink"]
weight_initialization_schemes = ["xavier", "default", "uniform"]

data = {}
for fct in activation_functions:
    for init in weight_initialization_schemes:
        data[f"{fct}_{init}"] = defaultdict(list)
        for seed in seeds:
            with open(f"results/activation_function/{fct}_{init}_{seed}.out") as file:
                for line in file:
                    if line.startswith("Proxies".center(100, "#")):
                        line = next(file)
                        line = line.replace("-inf", "-1e-40")
                        tmp = ast.literal_eval(line)
                        for measure in tmp.keys():
                            data[f"{fct}_{init}"][measure].append(tmp[measure])
                    if line.startswith("Test accuracy"):
                        accuracy, loss = re.findall("(\d+.\d+)", line)
                        data[f"{fct}_{init}"]["accuracy"].append(float(accuracy))
                        data[f"{fct}_{init}"]["loss"].append(float(loss))

for measure in list(data[f"{fct}_{init}"].keys())[:-2]:
    accuracies = []
    scores = []
    for fct in activation_functions:
        for init in weight_initialization_schemes:
            accuracies.append(np.mean(data[f"{fct}_{init}"]["accuracy"]))
            scores.append(np.mean(data[f"{fct}_{init}"][measure]))
    print(f"{measure}: SPR: {scipy.stats.spearmanr(accuracies, scores).statistic:.2f}, KT: {scipy.stats.kendalltau(accuracies, scores).statistic:.2f}")
