#!/usr/bin/python3

'''
Lifelong Machine Learning Potentials (lMLP)
'''
__copyright__ = '''This code is licensed under the 3-clause BSD license.
Copyright ETH Zurich, Department of Chemistry and Applied Biosciences, Reiher Group.
See LICENSE.txt for details.'''

# Set Numba, NumPy, and PyTorch number of threads
from os import environ
if environ.get('NUMBA_NUM_THREADS') is None:
    environ['NUMBA_NUM_THREADS'] = '1'
if environ.get('MKL_NUM_THREADS') is None:
    environ['MKL_NUM_THREADS'] = '1'
if environ.get('OMP_NUM_THREADS') is None:
    environ['OMP_NUM_THREADS'] = '1'

from ._version_ import __version__
from .lmlp import lMLP
from .lmlp_calculator import lMLP_calculator
from .core import CoRe
