#!/usr/bin/python3

####################################################################################################

####################################################################################################

'''
Lifelong Machine Learning Potentials (lMLP)
'''
__copyright__ = '''This code is licensed under the 3-clause BSD license.
Copyright ETH Zurich, Department of Chemistry and Applied Biosciences, Reiher Group.
See LICENSE.txt for details.'''

####################################################################################################

####################################################################################################

from os import environ
from numba import jit   # type: ignore


####################################################################################################

####################################################################################################

# decorator for disabled Numba just-in-time compilation
def nojit(func):
    '''
    No Numba just-in-time compilation
    '''
    return func


# for NUMBA_JIT=0 turn off Numba just-in-time compilation
if environ.get('NUMBA_JIT') == '0':
    ncjit = nojit
    ncfjit = nojit
    ncfpjit = nojit

# construct decorators for Numba just-in-time compilation
else:
    assert environ.get('NUMBA_NUM_THREADS') is not None, \
        'ERROR: Environment variable NUMBA_NUM_THREADS is not set.'
    ncjit = jit(nopython=True, cache=True)
    ncfjit = jit(nopython=True, cache=True, fastmath=True)
    ncfpjit = jit(nopython=True, cache=True, fastmath=True, parallel=True)
