# NAS-Benchmarks
## Reproduce Results
The code uses [Celery](https://docs.celeryq.dev) to distribute neural networks to workers that can be launched on 
different machines.

To reproduce the results given in the paper proceed as follows:

1. Install the requirements listed in [requirements.txt](requirements.txt) by running `pip install -r requirements.txt`.

2. [Install a redis server](https://redis.io/docs/latest/operate/oss_and_stack/install/install-redis/install-redis-on-linux/) 
that will be used as a broker for Celery.

3. Start the redis server and use the redis-cli to set a password with the command `CONFIG SET requirepass newpassword`.

4. Change the broker url in `NATSBench_celery.py` from `redis://:Xcrdb3rDeEf@172.31.55.178:27010/` 
to your own password, ip, and port.

5. Use the command `celery -A NATSBench_celery worker --loglevel=INFO` on all machines you want to
use. By default, it will spawn as many workers as the machines have cores.

6. To distribute the tasks to the workers you can use the following code:
    ```python3
    from NATSBench_celery import *

    for model_id in range(32768):
        train.delay(model_id)
    ```

7. The results for each network are stored in separate files. You can combine them by running:
    ```python3
    import glob
    import re

    stats = {}
    for filename in glob.glob("*.json"):
        model_id = re.findall(r"\d+", filename)[0] # for NATS-Bench
        with open(filename) as f:
            stats[model_id] = json.load(f)
    ```

8. Use the script [plot.py](plot.py) to reproduce figure A.6.

## Copyright Notice
To allow a fair comparison with proxies from the literature, we use code from previous publications. 
The adaptations made are for the sole purpose of integrating the code into our software.
Please note the copyright and license at the top of each file.

* [fisher.py](proxies/fisher.py), [grad_norm.py](proxies/grad_norm.py), [grasp.py](proxies/grasp.py), 
[snip.py](proxies/snip.py), [synflow.py](proxies/synflow.py) are adapted from Ref. 1
and licensed under the Apache License, Version 2.0
* [meco.py](proxies/meco.py) is adapted from Ref. 2 and licensed under the MIT license
* [swap.py](proxies/swap.py) is adapted from Ref. 3 and licensed under the Academic Free License version 3.0
* [zen.py](proxies/zen.py) is adapted from Ref. 4 and licensed under the Apache License, Version 2.0
* [zico.py](proxies/zico.py) is adapted from Ref. 5 and licensed under the Apache License, Version 2.0


[1] M. S. Abdelfattah, A. Mehrotra, Ł. Dudziak, and N. D. Lane, 
    Zero-cost proxies for lightweight NAS, 
    in 9th International Conference on Learning Representations (ICLR) (2021).

[2] T. Jiang, H. Wang, and R. Bie, 
    MeCo: Zero-shot NAS with one data and single forward pass via minimum eigenvalue of correlation, 
    in Adv. Neural Inf. Process. Syst., Vol. 36 (2023) pp. 61020–61047.

[3] Y. Peng, A. Song, H. M. Fayek, V. Ciesielski, and X. Chang, 
    SWAP-NAS: Sample-wise activation patterns for ultra-fast NAS, 
    in 12th International Conference on Learning Representations (ICLR) (Vienna, Austria, 2024).

[4] M. Lin, P. Wang, Z. Sun, H. Chen, X. Sun, Q. Qian, H. Li, and R. Jin, 
    Zen-NAS: A zero-shot NAS for high-performance image recognition, 
    in Proc. IEEE Int. Conf. Comput. Vis. (2021) pp. 347–356.

[5] G. Li, Y. Yang, K. Bhardwaj, and R. Marculescu, 
    ZiCo: Zero-shot NAS via inverse coefficient of variation on gradients, 
    in 11th International Conference on Learning Representations (ICLR) (Kigali, Rwanda, 2023).
