"""
Taken from: https://github.com/automl/NASLib/blob/zerocost/naslib/search_spaces/transbench101/loss.py

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import torch
from torch.nn import functional as F
from torch.nn.modules.loss import _WeightedLoss

class SoftmaxCrossEntropyWithLogits(_WeightedLoss):
    def __init__(self, weight=None):
        super(SoftmaxCrossEntropyWithLogits, self).__init__(weight=None)
        self.weight = weight

    def forward(self, input, target):
        logits_scaled = torch.log(F.softmax(input, dim=-1) + 0.00001)

        if self.weight is not None:
            loss = -((target * logits_scaled) * self.weight).sum(dim=-1)
        else:
            loss = -(target * logits_scaled).sum(dim=-1)
        return loss.mean()
