import glob
import json
import scipy
import numpy as np

measures = ["effective_rank", "meco_opt", "num_param", "flops"]
stats = {}
for filename in glob.glob("*.json"):
    with open(filename) as f:
        stats = json.load(f)

for measure in measures:
    scores = []
    acc = []
    for model_id in stats.keys():
        if stats[model_id]["perplexity"]:
            scores.append(stats[model_id][measure])
            acc.append(stats[model_id]["perplexity"])
    ind = np.argsort(scores)
    scores = np.array(scores)[ind]
    acc = np.array(acc)[ind]
    print(f"For {measure} PR: {scipy.stats.spearmanr(scores, acc).statistic:.2f}, KT: {scipy.stats.kendalltau(scores, acc).statistic:.2f}")
print(len(scores))
